﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_SOUND_PARAMETERS_CTR_H_
#define NW_SND_CTRL_SOUND_PARAMETERS_CTR_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/ctrl/sndctrl_Config.h>
#include <nw/snd/ctrl/sndctrl_SequenceVariable.h>

namespace nw {
namespace snd {
namespace ctrl {

//---------------------------------------------------------------------------
//! @brief  Ctr 向けサウンドのパラメータ構造体です。
//---------------------------------------------------------------------------
struct SoundParameters
{
    f32  volume;                //!< 音量です。
    f32  pitch;                 //!< ピッチです。

    u32  startOffset;           //!< 再生開始位置です。

    f32  pan;                   //!< パンです。
    f32  surroundPan;           //!< サラウンドパンです。

    f32  lpfFrequency;          //!< LPF 周波数です。
    s32  biquadFilterType;      //!< Biquad フィルタの種類です。
    f32  biquadFilterValue;     //!< Biquad フィルタのかかり具合です。

    f32  mainSend;                                          //!< メインバスのセンド量です。
    f32  fxSend[Limits::MAX_EFFECT_BUS_COUNT];              //!< 各エフェクトバスのセンド量です。

    bool tracksMute[Limits::MAX_SEQUENCE_TRACK_COUNT];      //!< シーケンストラックのミュートフラグです。
    f32  tracksVolume[Limits::MAX_SEQUENCE_TRACK_COUNT];    //!< シーケンストラックの音量です。

    // 再生開始時にシーケンス変数を設定するためのコンテナ
    //! @briefprivate
    internal::SequenceVariableContainer localVariables;
    //! @briefprivate
    internal::SequenceVariableContainer trackVariables[ internal::SequenceVariableTraits::TrackCount ];

    SoundParameters() :
      volume(1.f),
      pitch(1.f),
      startOffset(0),
      pan(0.f),
      surroundPan(0.f),
      lpfFrequency(0.f),
      biquadFilterType(BIQUAD_FILTER_TYPE_INHERIT),
      biquadFilterValue(0.5f),
      mainSend(0.f)
    {
        for (u32 index = 0; index < Limits::MAX_EFFECT_BUS_COUNT; ++index)
        {
            fxSend[index] = 0.f;
        }

        for (u32 index = 0; index < Limits::MAX_SEQUENCE_TRACK_COUNT; ++index)
        {
            tracksMute[index] = false;
            tracksVolume[index] = 1.0f;
        }
    }
};

} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_CTRL_SOUND_PARAMETERS_CTR_H_
