﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MIDDLEWARE_SYMBOL_H_
#define NW_MIDDLEWARE_SYMBOL_H_

// 本ヘッダ内のマクロは、ライブラリ開発者用です。ユーザは利用しないでください。

#if defined(NW_PLATFORM_CAFE) && defined(NW_COMPILER_GHS)

#include <nw/assert.h>
#include <nw/version.h>
#include <nn/middleware.h>

// マクロを評価して文字列にする
#define NW_MACROTO_STR_IMPL(x)          #x
#define NW_MACROTO_STR(macroArg)  NW_MACROTO_STR_IMPL(macroArg)

// NW4F_1_10_0_module_name のような文字列を作るマクロ
#define NW_MIDDLEWARE_SYMBOL(module_name) "NW4F_" NW_MACROTO_STR(NW_VERSION_MAJOR) "_" NW_MACROTO_STR(NW_VERSION_MINOR) "_" NW_MACROTO_STR(NW_VERSION_MICRO) "_" #module_name

// ミドルウェア情報を設定するマクロ。
// モジュールシンボルは 16文字以内という制限があるのでコンパイル時アサートでチェックしています。
#define NW_PUT_MIDDLEWARE_SYMBOL(module_name)                                            \
NN_DEFINE_MIDDLEWARE(moduleInfo, "NINTENDO", NW_MIDDLEWARE_SYMBOL(module_name));         \
NN_USING_MIDDLEWARE(moduleInfo);                                                         \
NW_STATIC_ASSERT(sizeof(NW_MIDDLEWARE_SYMBOL(module_name))-1 <= 16); // max 16 characters.

#else // NW_PLATFORM_CAFE

#define NW_PUT_MIDDLEWARE_SYMBOL(module_name)

#endif // NW_PLATFORM_CAFE

#endif // NW_MIDDLEWARE_SYMBOL_H_
