﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MCS_PCIO2COMMDEVICE_H_
#define NW_MCS_PCIO2COMMDEVICE_H_

#if defined(__CWCC__)
#pragma once
#endif

#include <nw/mcs/mcs_Base.h>
#include <nw/mcs/mcs_Common.h>

namespace nw
{
namespace mcs
{
namespace internal
{

#if defined(NW_MCS_ENABLE)

class PCIO2CommDevice : public CommDevice
{
public:
    //---------------------------------------------------------------------------
    //! @brief 通信デバイスの列挙を行います。
    //!
    //! @details
    //! 通信デバイスを見つけると、 pEnumerate の Find メソッドを呼び出します。
    //!
    //! @param[in]  enumerate    通信デバイスを見つけたときに呼び出される
    //!                          Find メソッドを実装するオブジェクトです。
    //!
    //! @return
    //! 列挙を続ける場合は true を返します。
    //---------------------------------------------------------------------------
    static bool EnumerateDevice(IDeviceEnumerate& enumerate);

    //---------------------------------------------------------------------------
    //! @brief 通信デバイスに必要なメモリサイズを取得します。
    //!
    //! @return
    //! 通信デバイスに必要なメモリ量（バイト数）を返します。
    //---------------------------------------------------------------------------
    static u32 GetDeviceObjectMemSize(const DeviceInfo& deviceInfo);

    //---------------------------------------------------------------------------
    //! @brief 通信デバイスを作成します。
    //!
    //! @param[in] mem  通信デバイスのために確保したメモリのアドレスです。
    //! @param[in] deviceInfo  デバイス情報です。
    //!
    //! @return 通信デバイスのオブジェクトを返します。
    //---------------------------------------------------------------------------
    static CommDevice* Construct(void* mem, const DeviceInfo& deviceInfo);
};

#endif  // #if defined(NW_MCS_ENABLE)

}   // namespace internal
}   // namespace mcs
}   // namespace nw

/* NW_MCS_PCIO2COMMDEVICE_H_ */
#endif
