﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_GFND_MEMORY_H_
#define NW_GFND_MEMORY_H_

#include <nw/types.h>

#if defined(NW_PLATFORM_CAFE)

#include <cafe/mem/frameHeap.h>

namespace nw
{
namespace gfnd
{

//---------------------------------------------------------------------------
//! @brief フレームヒープアロケータクラスです。
//!
//! @details :private
//---------------------------------------------------------------------------
class FrameHeapAllocator
{
    NW_DISALLOW_COPY_AND_ASSIGN(FrameHeapAllocator);

public:
    static const int MANAGER_WORK_AREA_SIZE = sizeof(MEMiHeapHead) + sizeof(MEMiFrmHeapHead);

    FrameHeapAllocator() : m_Handle(MEM_HEAP_INVALID_HANDLE) {}
    ~FrameHeapAllocator()
    {
        Shutdown();
    }

    void Initialize(void* startAddress, u32 size)
    {
        m_Handle = MEMCreateFrmHeap(startAddress, size);
    }

    void* Shutdown()
    {
        void* startAddress = NULL;
        if (m_Handle != MEM_HEAP_INVALID_HANDLE)
        {
            startAddress = MEMDestroyFrmHeap(m_Handle);
        }
        return startAddress;
    }

    void* Allocate(u32 size)
    {
        return MEMAllocFromFrmHeap(m_Handle, size);
    }

    void* Allocate(u32 size, u32 alignment)
    {
        return MEMAllocFromFrmHeapEx(m_Handle, size, alignment);
    }

private:
    MEMHeapHandle m_Handle;
};

} // namespace gfnd
} // namespace nw

#endif // defined(NW_PLATFORM_CAFE)

#endif // NW_GFND_MEMORY_H_
