﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>
#if EFT_IS_CAFE
#include <cafe/hio.h>
#endif

#include <nw/eft/eft2_Heap.h>
#include <nw/eft/eftvw2_CmdTaskBase.h>
#include <nw/eft/eftvw2_CmdReceiver.h>
#include <nw/eft/eftvw2_CmdSender.h>

namespace nw    {
namespace eftvw2  {
//------------------------------------------------------------------------------
//! @brief  HostIOクラス
//------------------------------------------------------------------------------
class ToolConnecter
{
public:
    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] heap     TBD
    //! @param[in] bufferSize     TBD
    //! @param[in] receive     TBD
    //! @param[in] sender     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static bool Initialize( nw::eft2::Heap* heap,
                            size_t bufferSize,
                            CmdReceiver* receive,
                            CmdSender* sender,
                            bool noUseInternalThread,
                            int priority );


    //------------------------------------------------------------------------------
    //! @brief TBD
    //------------------------------------------------------------------------------
    static void Finalize();

    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static bool IsConnected()
    {
        return s_isConnected;
    }

    //------------------------------------------------------------------------------
    //! @brief TBD
    //------------------------------------------------------------------------------
    static void SendPacket();

    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] intArg     TBD
    //! @param[in] ptrArg     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static int threadToolReceiver( int intArg, void* ptrArg );

private:
    //------------------------------------------------------------------------------
    //! @brief TBD
    //------------------------------------------------------------------------------
    ToolConnecter() {}

#if EFT_IS_CAFE
    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] status     TBD
    //! @param[in] context     TBD
    //------------------------------------------------------------------------------
    static void procStatusCallback( HIOStatus status, void* context );
#endif

    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] pBuffer     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static bool IsHandlePacket( u8* pBuffer );
    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] pBuffer     TBD
    //! @param[in] size     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static u8*  SkipPacket    ( u8* pBuffer, u32& size );
    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] handle     TBD
    //! @param[in] pReceiveBuffer     TBD
    //! @param[in] receiveSize     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static u32 receivePacket( const u32 handle, void* pReceiveBuffer, const u32 receiveSize );

    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] param     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static bool readPacket( u32 param );

    //------------------------------------------------------------------------------
    //! @brief TBD
    //! @param[in] param     TBD
    //! @return TBD
    //------------------------------------------------------------------------------
    static void sendPacket( u32 param );

private:
    static volatile bool s_isConnected; //!< TBD
};

} // namespace eftvw2
} // namespace nw
