﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __EFT_TOOL_H__
#define __EFT_TOOL_H__

#include <nw/config.h>
#include "typeDef2.h"

namespace nw   {
namespace math {

struct VEC2
{
    f32 x;
    f32 y;
};
struct VEC3
{
    f32 x;
    f32 y;
    f32 z;
};
struct VEC4
{
    f32 x;
    f32 y;
    f32 z;
    f32 w;
};
struct MTX34
{
    struct BaseData
    {
        f32 _00, _01, _02, _03;
        f32 _10, _11, _12, _13;
        f32 _20, _21, _22, _23;
    };
    union
    {
        struct
        {
            f32 _00, _01, _02, _03;
            f32 _10, _11, _12, _13;
            f32 _20, _21, _22, _23;
        };
        BaseData f;
        f32 m[3][4];
        f32 a[12];
        VEC4 v[3];
    };
};
struct MTX44
{
    struct BaseData
    {
        f32 _00, _01, _02, _03;
        f32 _10, _11, _12, _13;
        f32 _20, _21, _22, _23;
        f32 _30, _31, _32, _33;
    };

    union
    {
        struct
        {
            f32 _00, _01, _02, _03;
            f32 _10, _11, _12, _13;
            f32 _20, _21, _22, _23;
            f32 _30, _31, _32, _33;
        };
        BaseData f;
        f32 m[4][4];
        f32 a[16];
        VEC4 v[4];
    };
};

} // namespace math


namespace ut {

struct Color4f
{
public:
    f32 r; //!< カラーの R 要素です。
    f32 g; //!< カラーの G 要素です。
    f32 b; //!< カラーの B 要素です。
    f32 a; //!< カラーの A 要素です。

};

} // namespace ut

} // namespace nw

#endif  // __EFT_TOOL_H__
