﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>
#include <nw/eft/eft2_Enum.h>

namespace nw   {
namespace eft2 {

//---------------------------------------------------------------------------
//! @brief  描画クラス
//---------------------------------------------------------------------------
class Render
{
public:
    //---------------------------------------------------------------------------
    //! @brief  プリミティブタイプ
    //---------------------------------------------------------------------------
    typedef u32 PrimitiveType;
    //---------------------------------------------------------------------------
    //! @brief  プリミティブタイプ
    //---------------------------------------------------------------------------
    enum _PrimitiveType
    {
#ifdef EFT_OGL
        PRIM_TYPE_POINTS                    = GL_POINTS,            //!< POINTS
        PRIM_TYPE_TRIANGLES                 = GL_TRIANGLES,         //!< TRIANGLES
        PRIM_TYPE_TRIANGLE_STRIP            = GL_TRIANGLE_STRIP,    //!< TRIANGLE_STRIP
#endif
#if EFT_OPENGL
        PRIM_TYPE_QUADS                     = GL_QUADS,             //!< QUADS
#endif

#if EFT_GX2
        PRIM_TYPE_POINTS                    = GX2_PRIMITIVE_POINTS,                 //!< POINTS
        PRIM_TYPE_TRIANGLES                 = GX2_PRIMITIVE_TRIANGLES,              //!< TRIANGLES
        PRIM_TYPE_TRIANGLE_STRIP            = GX2_PRIMITIVE_TRIANGLE_STRIP,         //!< TRIANGLE_STRIP
        PRIM_TYPE_QUADS                     = GX2_PRIMITIVE_QUADS,                  //!< QUADS
#endif
    };

#if EFT_PARTICLE_PRIM_TRIANGLES_MODE
    static const PrimitiveType PARTICLE_PRIM_TYPE = PRIM_TYPE_TRIANGLE_STRIP;   //!< パーティクルのプリミティブタイプ
#else
    static const PrimitiveType PARTICLE_PRIM_TYPE = PRIM_TYPE_QUADS;            //!< パーティクルのプリミティブタイプ
#endif

    //---------------------------------------------------------------------------
    //! @brief                  描画命令を発行する
    //! @param[in] primType     プリミティブタイプ
    //! @param[in] vertexNum    頂点数
    //---------------------------------------------------------------------------
    static void DrawPrimitive( PrimitiveType primType, u32 vertexNum );

    //---------------------------------------------------------------------------
    //! @brief                  描画命令を発行する
    //! @param[in] primType     プリミティブタイプ
    //! @param[in] vertexNum    頂点数
    //! @param[in] indexPtr     インデックスへのポインタ
    //! @param[in] primCount    プリミティブの数
    //---------------------------------------------------------------------------
    static void DrawInstanceIndexedPrimitive( PrimitiveType primType, u32 vertexNum, const void* indexPtr, u32 primCount );

    //---------------------------------------------------------------------------
    //! @brief                  描画命令を発行する
    //! @param[in] primType     プリミティブタイプ
    //! @param[in] vertexNum    頂点数
    //! @param[in] indexPtr     インデックスへのポインタ
    //---------------------------------------------------------------------------
    static void DrawIndexedPrimitive( PrimitiveType primType, u32 vertexNum, const void* indexPtr );

    //---------------------------------------------------------------------------
    //! @brief                  描画命令を発行する
    //! @param[in] primType     プリミティブタイプ
    //! @param[in] startNum     先頭の配列インデックス
    //! @param[in] vertexNum    頂点数
    //---------------------------------------------------------------------------
    static void DrawPrimitive( PrimitiveType primType, u32 startNum, u32 vertexNum );

    //---------------------------------------------------------------------------
    //! @brief                  描画命令を発行する
    //! @param[in] primType     プリミティブタイプ
    //! @param[in] vertexNum    頂点数
    //! @param[in] primCount    プリミティブの数
    //---------------------------------------------------------------------------
    static void DrawInstancePrimitive( PrimitiveType primType, u32 vertexNum, u32 primCount );

    //---------------------------------------------------------------------------
    //! @brief                      描画命令を発行する
    //! @param[in] primType         プリミティブタイプ
    //! @param[in] vertexNum        頂点数
    //! @param[in] indexPtr         インデックスへのポインタ
    //! @param[in] primCount        プリミティブの数
    //! @param[in] baseVertexNum    ベースとなるインスタンスのインデックス値
    //---------------------------------------------------------------------------
    static void DrawBaseInstancePrimitive( PrimitiveType primType, u32 vertexNum, const void* indexPtr, u32 primCount, u32 baseVertexNum );
};

} // namespace eft2
} // namespace nw
