﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/math.h>
#include <nw/dw/system/dw_IUIRenderContext.h>
#include <nw/dw/system/dw_UIRenderer.h>

namespace nw {
namespace internal {
namespace dw {

class Window;

class WindowContext : public IUIRenderContext
{
public:
    /* ctor */ WindowContext();
    /* dtor */ virtual ~WindowContext() { }

public:
    void Initialize(f32 screenWidth, f32 screenHeight);

    const Window* PushWindow(const Window& window, UIRenderer& renderer);
    void PopWindow(const Window* pPreviousWindow, UIRenderer& renderer);

    const Window* GetCurrentWindow() const;

    const nw::math::Vector2& GetScreenSize() const
    {
        return m_ScreenSize;
    }

    /* override */ const nw::math::Vector2& GetRenderOffset() const
    {
        return nw::math::Vector2::Zero();
    }

private:
    nw::math::Vector2 m_ScreenSize;

    const Window* m_pCurrentWindow;
};

} // dw
} // internal
} // nw
