﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief ドッキングの方法を示します。
//---------------------------------------------------------------------------
enum Dock
{
    DOCK_FILL = 0,
    DOCK_LEFT,
    DOCK_TOP,
    DOCK_RIGHT,
    DOCK_BOTTOM,
};

//---------------------------------------------------------------------------
//! @brief 横方向の配置を示します。
//---------------------------------------------------------------------------
enum HorizontalAlignment
{
    HORIZONTAL_LEFT = 0,
    HORIZONTAL_CENTER,
    HORIZONTAL_RIGHT,
    HORIZONTAL_STRETCH,
};

//---------------------------------------------------------------------------
//! @brief サイズの決定方法を示します。
//---------------------------------------------------------------------------
enum Measurement
{
    MEASUREMENT_MANUAL = 0,
    MEASUREMENT_AUTO_WIDTH = 1,
    MEASUREMENT_AUTO_HEIGHT = 2,
    MEASUREMENT_AUTO = MEASUREMENT_AUTO_WIDTH | MEASUREMENT_AUTO_HEIGHT,
};

//---------------------------------------------------------------------------
//! @brief 並びの方向を示します。
//---------------------------------------------------------------------------
enum Orientation
{
    HORIZONTAL = 0,
    VERTICAL,
};

//---------------------------------------------------------------------------
//! @brief テキストの配置を示します。
//---------------------------------------------------------------------------
enum TextAlignment
{
    TEXT_LEFT = 0,
    TEXT_CENTER,
    TEXT_RIGHT,
};

//---------------------------------------------------------------------------
//! @brief 縦方向の配置を示します。
//---------------------------------------------------------------------------
enum VerticalAlignment
{
    VERTICAL_TOP = 0,
    VERTICAL_CENTER,
    VERTICAL_BOTTOM,
    VERTICAL_STRETCH,
};

//---------------------------------------------------------------------------
//! @brief 可視性を示します。
//---------------------------------------------------------------------------
enum Visibility
{
    VISIBLE = 0,
    HIDDEN,
    COLLAPSED,
};

} // dw
} // internal
} // nw
