﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dev/dev_Mouse.h>
#include <nw/math/math_Vector2.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief 入力を示します。
//---------------------------------------------------------------------------
class Inputs
{
public:
    /* ctor */ Inputs(const dev::Pad* pPad, const dev::Mouse* pMouse) :
        m_pPad(pPad),
        m_pMouse(pMouse),
        m_PointerPosition(0.f, 0.f)
    {
        if(pMouse != NULL)
        {
            m_PointerPosition = pMouse->GetPointer();
        }
    }

    /* ctor */ Inputs(const Inputs& source) :
        m_pPad(source.GetPad()),
        m_pMouse(source.GetMouse()),
        m_PointerPosition(source.GetPointerPosition())
    {
    }

public:
    const nw::dev::Pad* GetPad() const
    {
        return m_pPad;
    }

    const nw::dev::Mouse* GetMouse() const
    {
        return m_pMouse;
    }

    const nw::math::Vector2& GetPointerPosition() const
    {
        return m_PointerPosition;
    }

    Inputs& SetPointerPosition(f32 x, f32 y)
    {
        m_PointerPosition.x = x;
        m_PointerPosition.y = y;
        return *this;
    }

    Inputs& SetPointerPosition(const nw::math::Vector2& value)
    {
        m_PointerPosition = value;
        return *this;
    }

private:
    const nw::dev::Pad* m_pPad;
    const nw::dev::Mouse* m_pMouse;
    nw::math::Vector2 m_PointerPosition;
};

} // dw
} // internal
} // nw
