﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace internal {
namespace dw {

class UIElement;

class UIElementListEventArgs
{
public:
    static const u32 INVALID_INDEX = static_cast<u32>( -1 );

    enum Action
    {
        INSERT_ITEM,
        REMOVE_ITEM,
    };

public:
    UIElementListEventArgs() :
      m_Action(INSERT_ITEM),
        m_Index(INVALID_INDEX),
        m_pItem(NULL)
    {
    }

    explicit UIElementListEventArgs(Action action, u32 index, UIElement* pItem) :
        m_Action(action),
        m_Index(index),
        m_pItem(pItem)
    {
    }

public:
    Action GetAction() const
    {
        return m_Action;
    }

    u32 GetIndex() const
    {
        return m_Index;
    }

    UIElement* GetItem() const
    {
        return m_pItem;
    }

private:
    Action m_Action;
    u32 m_Index;
    UIElement* m_pItem;
};

} // dw
} // internal
} // nw
