﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
SelectableParameterListItem<TModel,TValue>::SelectableParameterListItem(TValue defaultValue)
 : m_Enums( NULL ),
   m_DefaultValue( defaultValue ),
   m_pGetValueHandler( NULL ),
   m_pSetValueHandler( NULL ),
   m_pPrintValueHandler( NULL )
{
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::Initialize(
    const IEnums* enumList,
    GetValueHandler pGetValueHandler,
    SetValueHandler pSetValueHandler,
    PrintValueHandler pPrintValueHandler
)
{
    NW_ASSERTMSG( m_pGetValueHandler == NULL, "SelectableParameterListItem is already initialized." );
    NW_ASSERTMSG( m_pSetValueHandler == NULL, "SelectableParameterListItem is already initialized." );
    NW_ASSERTMSG( m_pPrintValueHandler == NULL, "SelectableParameterListItem is already initialized." );
    NW_ASSERT( pGetValueHandler != NULL );
    NW_ASSERT( pSetValueHandler != NULL );
    NW_ASSERT( pPrintValueHandler != NULL );

    m_Enums = enumList;

    m_pGetValueHandler = pGetValueHandler;
    m_pSetValueHandler = pSetValueHandler;
    m_pPrintValueHandler = pPrintValueHandler;
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
TValue
SelectableParameterListItem<TModel,TValue>::GetValue() const
{
    NW_ASSERTMSG(m_pGetValueHandler != NULL, "SelectableParameterListItem is not initialized.");
    return (*m_pGetValueHandler)( GetModel() );
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::SetValue(TValue value)
{
    NW_ASSERTMSG(m_pSetValueHandler != NULL, "SelectableParameterListItem is not initialized.");
    (*m_pSetValueHandler)(GetModel(), value);
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::ResetValue()
{
    SetValue( m_DefaultValue );
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
TValue
SelectableParameterListItem<TModel,TValue>::GetDefaultValue() const
{
    return m_DefaultValue;
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::SetDefaultValue(TValue value)
{
    m_DefaultValue = value;
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::NextValue(bool isLargeChange)
{
    TValue currentValue = GetValue();
    TValue newValue = currentValue;
    bool isCurrentValueFound = false;

    if ( m_Enums->size() > 0 )
    {
        for ( u32 i = 0; i <= m_Enums->size(); ++i )
        {
            if ( isCurrentValueFound )
            {
                if ( i < m_Enums->size() )
                {
                    newValue = static_cast<TValue>( m_Enums->value( i ) );
                }
                else if ( this->GetValueLoop() )
                {
                    newValue = static_cast<TValue>( m_Enums->value( 0 ) );
                }

                break;
            }

            isCurrentValueFound = ( currentValue == static_cast<TValue>( m_Enums->value( i ) ) );
        }
    }

    SetValue( newValue );
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::PreviousValue(bool isLargeChange)
{
    TValue currentValue = GetValue();
    TValue newValue = currentValue;

    for ( u32 i = 0; i < m_Enums->size(); ++i )
    {
        if ( currentValue == static_cast<TValue>( m_Enums->value( i ) ) )
        {
            if ( this->GetValueLoop() && i == 0 )
            {
                newValue = static_cast<TValue>( m_Enums->value( m_Enums->size() - 1 ) );
            }

            break;
        }

        newValue = static_cast<TValue>( m_Enums->value( i ) );
    }

    SetValue(newValue);
}

//---------------------------------------------------------------------------
template<class TModel, typename TValue>
void
SelectableParameterListItem<TModel,TValue>::PrintValue(char* pText, u32 bufferLength)
{
    (*m_pPrintValueHandler)( GetModel(), pText, bufferLength, this->GetValue() );
}

} /* namespace dw */
} /* namespace internal */
} /* namespace nw */
