﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_UIElementUtility.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief フォーカス可能UI要素を検索する関数オブジェクトです。
//---------------------------------------------------------------------------
class FocusableElementFinder : public nw::internal::dw::UIElementUtility::UnaryFunction
{
public:
    FocusableElementFinder();

public:
    void Reset();
    UIElement* GetResult() const;

    /*override*/ bool operator ()(nw::internal::dw::UIElement& element);

private:
    UIElement* m_pResult;
};

} // dw
} // internal
} // nw
