﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_ListBox.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_FixedUIElementList.h>

namespace nw {
namespace internal {
namespace dw {

template<u32 TItemCount>
class FixedListBox : public ListBox
{
private:
    typedef ListBox Base;

public:
    FixedListBox()
    {
        Initialize();
    }

    FixedListBox(const UIElement** ppItems, u32 count)
    {
        Initialize();

        u32 itemCount = nw::ut::Min(count, TItemCount);

        for(u32 i=0; i<itemCount; ++i)
        {
            AddItem(ppItems[i]);
        }
    }

    virtual ~FixedListBox() { }

public:
    virtual ListBoxItemPlaceHolder& GetItemPlaceHolder(s32 index)
    {
        NW_ASSERT(0 <= index && index < TItemCount);
        return m_ItemPlaceHolders[index];
    }

    virtual const ListBoxItemPlaceHolder& GetItemPlaceHolder(s32 index) const
    {
        NW_ASSERT(0 <= index && index < TItemCount);
        return m_ItemPlaceHolders[index];
    }

protected:
    virtual UIElementList& GetItems() { return m_Container.GetContents(); }

    virtual const UIElementList& GetItems() const { return m_Container.GetContents(); }


private:
    void Initialize()
    {
        NW_ASSERT(GetItemCount() == 0);

        m_Contents.AddItem(&m_Container);
        SetContents(m_Contents);
    }

private:
    FixedUIElementList<1> m_Contents;
    FixedStackPanel<TItemCount> m_Container;
    ListBoxItemPlaceHolder m_ItemPlaceHolders[TItemCount];

#if defined(NW_DEBUG) || defined(NW_DEVELOP)

private:
    static const u32 DEBUG_TEXT_LENGTH = 32;

public:
    virtual const char* ToString() const
    {
        ut::snprintf(const_cast<char*>(m_DebugText), sizeof(m_DebugText), sizeof(m_DebugText) - 1, "FixedListBox<%d>", TItemCount);
        return m_DebugText;
    }

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];

#endif
};

} // dw
} // internal
} // nw
