﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedLabel.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  ディレクトリ、ファイルのエントリーを示す UI 要素です。
//---------------------------------------------------------------------------
class FileBrowserEntry : public UIElement
{
private:
    typedef UIElement Base;

    static const u32 MAX_FILE_PATH = 256;

public:
    FileBrowserEntry();
    virtual ~FileBrowserEntry();

public:
    bool GetIsDirectory();
    void SetIsDirectory(bool value);

    const char* GetText();
    void SetText(const char* value);

private:
    FixedUIElementList<1> m_Contents;
    FixedLabel<MAX_FILE_PATH + 1> m_Label;
    bool m_IsDirectory;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "FileBrowserEntry";
    }
#endif
};

} // dw
} // internal
} // nw
