﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdio.h>

#if !defined(NW_RELEASE)
  #define NW_CONSOLE_ENABLE
#endif

#define NW_LITTLE_ENDIAN

// ANDROIDプラットフォームでは、リソースのエンディアンを全てひっくり返す
#define NW_UT_RES_SWAP_ENDIAN

#define NW_ENABLE_FLOAT64


#define NW_PLATFORM_NAME     Android
#define NW_PLATFORM_ANDROID

#define NW_HALT     do { int* a = NULL; *a = 1; } while ((void)0, 0);

#ifdef NW_FROM_TOOL

  #define NW_TLOG     printf
  #define NW_LOG      printf

#else

#if defined(NW_CONSOLE_ENABLE)
  #define NW_TLOG    ::nw::ut::TPrintf
  #define NW_LOG     ::nw::ut::Printf
#else
  #define NW_TLOG(...) ((void)0)
  #define NW_LOG(...)  ((void)0)
#endif

namespace nw {
namespace ut {
    void Printf(const char *fmt, ...);
    void TPrintf(const char *fmt, ...);
    void Panic( const char* fileName, int line, const char* fmt, ...);
    void TPanic( const char* fileName, int line, const char* fmt, ...);

    void HaltWithDetail(const char* codePos, int lineNo, const char* format, ...);
} // namespace ut



} // namespace nw
#endif // #ifdef NW_FROM_TOOL

// TODO: cmath && C言語のsinf等のfloat版関数が使えなかったので、とりあえずこれで対処
#include <cmath>
#define MATH_FUNC_FLOAT(func_name) inline float func_name ## f(float val) { return func_name(val); }
#define MATH_FUNC_FLOAT2(func_name) inline float func_name ## f(float val1, float val2) { return func_name(val1, val2); }
namespace std
{
    MATH_FUNC_FLOAT(ceil)
    MATH_FUNC_FLOAT(sqrt)
    MATH_FUNC_FLOAT(sin)
    MATH_FUNC_FLOAT(cos)
    MATH_FUNC_FLOAT(sinh)
    MATH_FUNC_FLOAT(log10)
    MATH_FUNC_FLOAT(tan)
    MATH_FUNC_FLOAT(log)
    MATH_FUNC_FLOAT(exp)

    MATH_FUNC_FLOAT(asin)
    MATH_FUNC_FLOAT(acos)
    MATH_FUNC_FLOAT(atan)
    MATH_FUNC_FLOAT2(atan2)
    MATH_FUNC_FLOAT(floor)
    MATH_FUNC_FLOAT(fabs)
    MATH_FUNC_FLOAT2(fmod)
    inline float modff(float val1, float *val2) { return ::std::modf(val1, val2); }
}
#undef MATH_FUNC_FLOAT
#undef MATH_FUNC_FLOAT2

