﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief シェアページを開くのに利用する API 宣言(非公開)
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/web/web_ShareShowArgPrivate.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
/**
 * @brief シェアページを開きます。
 *
 * @param[out]  pOutputSharePageReturnValue  シェアページを開いた戻り値の格納先を指定してください。
 * @param[in]   arg                          シェアページを開くのに利用されるパラメータです。
 *
 * @return 処理の結果を表す Result 値
 * @retval nn::ResultSuccess                    シェアページの表示に成功し、操作によって表示が終了されました。
 * @retval nn::la::ResultLibraryAppletCanceled  シェアページの表示中に強制的にキャンセルが行われて表示が終了されました。
 */
nn::Result ShowSharePage(SharePageReturnValue* pOutputSharePageReturnValue,
    const ShowSharePageArg& arg) NN_NOEXCEPT;

//------------------------------------------------------------------------
/**
 * @brief 指定した Storage からシェアページを開いた戻り値を取得します。
 *
 * @param[in,out]   pOutputSharePageReturnValue シェアページを開いた戻り値の格納先を指定してください。
 * @param[in]       handle                      nn::applet::TryPopFromOutChannel で取得した nn::applet::StorageHandle を指定してください。
 *
 * @return 処理の結果を表す Result 値
 * @retval nn::ResultSuccess 処理に成功しました。
 *
 * @details Unwind 時に戻り値を取得する為の機能です。
 *          handle から値を取り出すだけでリリース等は行いません。
 */
nn::Result GetSharePageReturnValueFromStorage(SharePageReturnValue* pOutputSharePageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT;

}} // namespace nn::web
