﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ロビーページを開くのに利用する API 宣言(非公開)
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/web/web_LobbyShowArgPrivate.h>
#include <nn/web/web_Result.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
/**
 * @brief ロビーページを開きます。
 *
 * @param[out]  pOutputLobbyPageReturnValue  ロビーページを開いた戻り値の格納先を指定してください。
 * @param[in]   arg                          ロビーページを開くのに利用されるパラメータです。
 *
 * @return 処理の結果を表す Result 値
 * @retval nn::ResultSuccess                    ロビーページの表示に成功し、操作によって表示が終了されました。
 * @retval nn::web::ResultTerminated            ロビーページの表示中に強制的にキャンセルが行われて表示が終了されました。
 */
nn::Result ShowLobbyPage(LobbyPageReturnValue* pOutputLobbyPageReturnValue,
    const ShowLobbyPageArg& arg) NN_NOEXCEPT;
}} // namespace nn::web
