﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ログインページを開くのに利用する API 宣言(内部関係者向け)
 */

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nn/web/web_LoginShowArgPrivate.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
/**
 * @brief Cruiser 内で ReturnValue を設定する為のクラスです。
 */
class LoginPageReturnValueDetail
    : protected LoginPageReturnValue
{
public:
    /**
     * @brief 終了理由を設定します。
     *
     * @param[in]   loginExitReason   終了理由を指定してください。
     *
     * @details 二度呼び出した場合値は上書きされます。
     */
    inline void SetLoginExitReason(LoginExitReason loginExitReason) NN_NOEXCEPT;

    /**
     * @brief 終了時開いていたページの URL を設定します。
     *
     * @param[in]   lastUrl ページの URL を指定してください。
     *
     * @details 指定する値は NULL 終端されている必要があります。
     *          LastUrlMaxLength -1 文字以下にする必要があります。
     *          二度呼び出した場合値は上書きされます。
     */
    inline void SetLastUrl(const char* lastUrl) NN_NOEXCEPT;
};

//------------------------------------------------------------------------
void LoginPageReturnValueDetail::SetLoginExitReason(LoginExitReason loginExitReason) NN_NOEXCEPT
{
    m_ExitReason = uint64_t(loginExitReason);
}

//------------------------------------------------------------------------
void LoginPageReturnValueDetail::SetLastUrl(const char* lastUrl) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(lastUrl);
    size_t size = std::strlen(lastUrl) + 1;
    NN_SDK_ASSERT(size <= LastUrlMaxLength);

    std::memcpy(m_LastUrl, lastUrl, size);

    m_LastUrlSize = uint64_t(size);
}

}} // namespace nn::web
