﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace rid {

    /**
     * @brief   試遊台関連ツールが実行できる本体であるかを確認します。
     *
     * @detail  試遊台フラグの確認を行い、試遊台関連ツールが実行できる本体であるかを確認します。
     *
     * @return  処理の結果が返ります。
     * @retval  ResultNotRetailInteractiveDisplayDevice 試遊台と関連するツールの実行ができる本体ではありません。
     */
    Result CheckRetailInteractiveDisplayDevice() NN_NOEXCEPT;

    /**
     * @brief   更新チェックモード開始時に必要な処理を行います。
     *
     * @detail  この関数内で使用している関数の互換性は維持される必要があります。
     *          この関数で下記の処理を行います。
     *          - 通知の無効化
     *          - ネットワーク独占利用要求の取り下げ
     *
     * @return  処理の結果が返ります。
     */
    Result MinimumStartUp() NN_NOEXCEPT;

    /**
     * @brief   試遊モード開始時に必要な処理を行います。
     *
     * @detail  この関数で下記の処理を行います。
     *          - 画面焼け軽減無効設定
     *          - 自動スリープ無効設定
     *          - 全タイトルのセーブデータ削除
     *          - アカウントの存在確認
     *
     * @return  処理の結果が返ります。
     * @retval  ResultAccountNotFound        体験版タイトルの起動に必要なアカウントが存在しません。
     */
    Result StartUp() NN_NOEXCEPT;
}}
