﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/fs/fs_IStorage.h>
#include "repair_IFile.h"

namespace nn
{
    namespace repair
    {
        class FileSystem
        {
        public:
            virtual nn::Result DeleteFile(const char *path) = 0;
            virtual nn::Result CreateFile(const char *path) = 0;
            virtual nn::Result OpenFile(std::shared_ptr<IFile> *pOut, const char *path, int mode) = 0;
            virtual nn::Result GetFileSize(int64_t *pOut, const char* path) = 0;
            virtual nn::Result Exists(bool *pOut, const char* path) = 0;

            static std::shared_ptr<FileSystem> Create(const char* type);
        };
    }
}
