﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace nd { namespace detail {

class SystemSaveData
{
public:
    SystemSaveData() NN_NOEXCEPT;
    ~SystemSaveData() NN_NOEXCEPT;

    Result Create(const char* path, size_t fileSize) NN_NOEXCEPT;
    Result Write(const char* path, const void* buffer, size_t bufferSize) NN_NOEXCEPT;
    Result Read(size_t* pOutActualSize, void* outBuffer, size_t outBufferSize, const char* path) NN_NOEXCEPT;
    Result Commit() NN_NOEXCEPT;
private:
    static const fs::SystemSaveDataId SystemSaveDataId = fs::SystemSaveDataId{ 0x8000000000000160llu };
    static const int64_t SystemSaveDataSize            = 48 * 1024;
    static const int64_t SystemSaveDataJournalSize     = 48 * 1024;
    static const fs::SaveDataFlags SaveDataFlags       = static_cast<fs::SaveDataFlags>(fs::SaveDataFlags_KeepAfterResettingSystemSaveDataWithoutUserSaveData);
    static constexpr const char* MountName             = "nd_sys";
    static const size_t FullPathLengthMax              = 64;

    void Mount() NN_NOEXCEPT;
    void Unmount() NN_NOEXCEPT;
    void GetFullPath(char(&outFullPath)[FullPathLengthMax], const char* path) const NN_NOEXCEPT;

    nn::os::SdkMutex m_Mutex;
};

}}} // ~namespace nn::nd::detail
