﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/migration/detail/migration_MigrationProgress.h>
#include <nn/migration/user/migration_UserMigrationContext.h>
#include <nn/os/os_Mutex.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace migration { namespace user {

class PerformanceMonitor
{
    // NOTE: このクラスはスレッドセーフでない

private:
    TimeSpan m_Duration;
    size_t m_Traffic;

    // 計測期間中
    bool m_IsMeasuring;
    TimeSpan m_StartedAt;
    size_t m_TrafficDelta;

public:
    PerformanceMonitor() NN_NOEXCEPT;

    float GetThroughput() const NN_NOEXCEPT;
    TimeSpan GetElapsedTime() const NN_NOEXCEPT;

    void Start() NN_NOEXCEPT;
    void Update(size_t dataSize) NN_NOEXCEPT;
    void End() NN_NOEXCEPT;
};

class ProgressMonitor final
    : public detail::ProgressMonitor
{
private:
    ClientContext& m_ClientContext;

    mutable os::Mutex m_Lock;
    bool m_IsReceiving;
    detail::DataInfo m_DataInfo;
    size_t m_Progress;

    PerformanceMonitor m_PerformanceMonitor;

public:
    explicit ProgressMonitor(ClientContext& clientContext) NN_NOEXCEPT;

    // 取得
    TransferInfo GetTransferInfo() const NN_NOEXCEPT;

    // 更新
    virtual void Start(const detail::DataInfo& dataInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Update(size_t dataSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual void End() NN_NOEXCEPT NN_OVERRIDE;
};

}}} // ~namespace nn::migration::user
