﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace migration { namespace detail {

#define NN_MIGRATION_DETAIL_MUTEX_INITIALIZER(recursive) { NN_OS_MUTEX_INITIALIZER(recursive) }

struct Mutex
{
    os::MutexType mutex;

    bool IsLockedByCurrentThread() NN_NOEXCEPT
    {
        return os::IsMutexLockedByCurrentThread(&mutex);
    }
    void lock() NN_NOEXCEPT
    {
        os::LockMutex(&mutex);
    }
    void unlock() NN_NOEXCEPT
    {
        os::UnlockMutex(&mutex);
    }
};

struct LockGuard
{
    Mutex* base;
    explicit LockGuard(Mutex& mutex) NN_NOEXCEPT
        : base(&mutex)
    {
        base->lock();
    }
    LockGuard() NN_NOEXCEPT
        : base(nullptr)
    {

    }
    LockGuard(LockGuard&& rhs) NN_NOEXCEPT
        : base(rhs.base)
    {
        rhs.base = nullptr;
    }
    ~LockGuard() NN_NOEXCEPT
    {
        if (base)
        {
            base->unlock();
        }
    }
    LockGuard& operator =(LockGuard&& rhs) NN_NOEXCEPT
    {
        if( base )
        {
            base->unlock();
        }
        base = rhs.base;
        rhs.base = nullptr;
        return *this;
    }
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return base != nullptr;
    }
};

}}} // ~namespace nn::migration::detail
