﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/detail/NetworkInterface/ldn_NetworkInterfaceProfile.h>

#if defined(NN_BUILD_CONFIG_OS_WIN)
    #include <nn/ldn/detail/TcpIp/ldn_TcpIpStackConfigurationImpl-os.win.h>
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include <nn/ldn/detail/TcpIp/ldn_TcpIpStackConfigurationImpl-os.horizon.h>
#endif

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief       TCP/IP の通信スタックのコンフィギュレーションを行います。
     */
    class TcpIpStackConfiguration
    {
    public:

        TcpIpStackConfiguration() NN_NOEXCEPT
            : m_Impl()
        {
        }

        ~TcpIpStackConfiguration() NN_NOEXCEPT
        {
        }

        void Startup(
            Ipv4Address address, Ipv4Address gateway, SubnetMask mask,
            const NetworkInterfaceProfile& profile) NN_NOEXCEPT
        {
            m_Impl.Startup(address, gateway, mask, profile);
        }

        void Down() NN_NOEXCEPT
        {
            m_Impl.Down();
        }

        void AddEntry(Ipv4Address ip, MacAddress mac) NN_NOEXCEPT
        {
            m_Impl.AddEntry(ip, mac);
        }

        void RemoveEntry(Ipv4Address ip) NN_NOEXCEPT
        {
            m_Impl.RemoveEntry(ip);
        }

        void ClearEntry() NN_NOEXCEPT
        {
            m_Impl.ClearEntry();
        }

    private:

        impl::TcpIpStackConfigurationImpl m_Impl;
    };

}}} // end of namespace nn::ldn::detail
