﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/detail/NetworkInterface/ldn_NetworkInterface.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         L2 上の端末のインタフェースです。
     */
    class NetworkInterfaceBase : public INetworkInterface
    {
        NN_DISALLOW_COPY(NetworkInterfaceBase);
        NN_DISALLOW_MOVE(NetworkInterfaceBase);

    public:

        NetworkInterfaceBase() NN_NOEXCEPT;

        virtual ~NetworkInterfaceBase() NN_NOEXCEPT;

        bool IsSupportedChannel(int channel) const NN_NOEXCEPT NN_OVERRIDE;

        bool IsAutoSelectableChannel(int channel) const NN_NOEXCEPT NN_OVERRIDE;

        int GetLinkLevel() const NN_NOEXCEPT NN_OVERRIDE;
    };

}}} // namespace nn::ldn::detail
