﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         Advertise のフォーマットを表す定数です。
     */
    enum AdvertiseFormat
    {
        //! フォーマットが指定されていません。
        AdvertiseFormat_None,

        //! SHA-256 による誤りチェックのみを行います。
        AdvertiseFormat_PlainSha256,

        //! Hardware AES + SHA-256 によって盗聴と改竄を防止します。
        AdvertiseFormat_Aes128CtrSha256
    };

}}} // namespace nn::ldn::detail
