﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/ldn/detail/Advertise/ldn_Advertise.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseBuilder.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseParser.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief           アドバータイズデータのボディ部分を生成します。
     * @param[out]      buffer          出力先のバッファです。
     * @param[out]      pOutSize        出力サイズです。
     * @param[in]       bufferSize      buffer のバッファサイズです。
     * @param[in]       ldn             Advertise データの生成に使用する元データです。
     */
    void CreateAdvertiseBody(
        void* buffer, size_t* pOutSize, size_t bufferSize,
        const LdnNetworkInfo& ldn) NN_NOEXCEPT;

    /**
     * @brief           アドバータイズデータのボディ部分を解析します。
     * @param[out]      pOut            解析結果の出力先です。
     * @param[in]       data            受信したアドバータイズの Body 部分です。
     * @param[in]       dataSize        data のバイトサイズです。
     * @return          解析に成功した場合に true です。
     */
    bool AnalyzeAdvertiseBody(
        LdnNetworkInfo* pOut, const void* data, size_t dataSize) NN_NOEXCEPT;

}}} // end of namespace nn::ldn::detail
