﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/lcs/detail/lcs_Context.h>
#include <nn/lcs/detail/lcs_Event.h>
#include <nn/lcs/detail/lcs_NetworkInfo.h>
#include <nn/lcs/detail/lcs_NodeManager.h>
#include <nn/lcs/detail/lcs_State.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/lcs/detail/lcs_Version.h>
#include <nn/lcs/detail/Packet/lcs_Packet.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_TimerEventTypes.h>
#include <nn/ns/ns_RequestServerStopper.h>
#include <nn/ns/ns_SystemUpdateApi.h>

namespace nn { namespace lcs { namespace detail
{
    // AppControlData を取得する際に使用するバッファ
    // アイコン 128KByte + データ 16 KByte が最大値となる
    const size_t AppControlDataSize = (128 + 16) * 1024;

    const size_t PacketSize = TcpDataSizeMax;

    // ApplicationDeliveryInfo を変換する用のバッファサイズ
    const size_t AppDeliveryInfoSize =
        ApplicationDeliveryInfoCountMax * sizeof(ApplicationDeliveryInfo);

    const int ThreadStackSize = 64 * 1024;

    struct LcsResources
    {
        NN_ALIGNAS(4096) char migrationThreadStack[ThreadStackSize];
        NN_ALIGNAS(4096) char monitorThreadStack[ThreadStackSize];
        NN_ALIGNAS(4096) char comThreadStack[ThreadStackSize];
        NN_ALIGNAS(4096) char shareThreadStack[ThreadStackSize];
        NN_ALIGNAS(4096) char timeoutThreadStack[ThreadStackSize];

        nn::os::MutexType mutex;

        char userName[UserNameBytesMax + 1];
        SessionSettings sessionSettings;
        uint8_t packetBuffer[PacketSize];
        char appControlDataBuffer[AppControlDataSize];
        char appDeliveryInfoDataBuffer[AppDeliveryInfoSize];
        ContentsShareFailureReason contentsShareFailureReason;
        SuspendedReason suspendedReason;
        Bit64 localCommunicationId;
        Version version;
        int monitorThreadPriority;
        int comThreadPriority;
        int shareThreadPriority;
        int timeoutThreadPriority;
        nn::os::ThreadType monitorThread;
        nn::os::ThreadType comThread;
        nn::os::ThreadType shareThread;
        nn::os::ThreadType timeoutThread;

        NetworkSetting currentNetworkSetting;

        bool isRunning;
        nn::os::EventType migrationEvent;
        MigrationInfo migrationInfo;

        StateMachine state;
        EventManager stateEvent;
        nn::ns::SystemUpdateControl systemUpdateControl;

        uint32_t myIndex;
        Ipv4Address hostAddress;
        AdvertiseData advertiseData;
        SessionInfo sessionInfo;
        int nodeInfoCount;
        NodeInfo nodeInfo[NodeCountMax];

        size_t requiredStorageSize;

        // Open / Join 時に持っていたコンテンツの情報保存用
        int ownAppInfoCount;
        ApplicationInfo ownAppInfo[SharableContentsCountMax];

        // 最新のコンテンツ情報保存用
        int shareAppInfoCount;
        ApplicationInfo shareAppInfo[SharableContentsCountMax];

        // インターネットからの DL タスク退避用
        DownloadTaskInfo downloadTaskInfo[SharableContentsCountMax];
        int downloadTaskInfoCount;

        // 進捗表示用
        int contentInfoCount;
        ContentsInfo contentInfo[DownloadableContentsCountMax];

        // NodeProgress 保存用
        int nodeDetailProgressCount;
        NodeDetailProgress nodeDetailProgress[NodeCountMax];

        ShareComponent shareComponent;
        ResumeContext context;
    };
    NN_STATIC_ASSERT(sizeof(LcsResources) < RequiredBufferSize);

}}} // end of namespace nn::lcs
