﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/lcs/detail/lcs_Version.h>
#include <nn/lcs/detail/lcs_NetworkInfo.h>
#include <nn/lcs/detail/Advertise/lcs_Advertise.h>

namespace nn { namespace lcs { namespace detail
{
    bool IsNetworkAvailable() NN_NOEXCEPT;

    bool IsAccessPointOpened() NN_NOEXCEPT;

    Result OpenAccessPoint() NN_NOEXCEPT;

    Result CloseAccessPoint() NN_NOEXCEPT;

    Result OpenStation() NN_NOEXCEPT;

    Result CloseStation() NN_NOEXCEPT;

    Result SetAdvertiseDataForNetwork(const void* data, size_t dataSize) NN_NOEXCEPT;

    Result CreateNetwork(Bit64 networkId, int nodeCountMax, const Version& version) NN_NOEXCEPT;

    Result CreateNetworkPrivate(
        const NetworkSetting& setting, AddressEntry* entry, int entryCount) NN_NOEXCEPT;

    Result Scan(
        SessionInfo* outBuffer, int* pOutCount, int bufferCount, Bit64 networkId) NN_NOEXCEPT;

    Result Connect(const NetworkSetting& setting, int16_t version) NN_NOEXCEPT;

    Result Disconnect() NN_NOEXCEPT;

    Result RejectOnNetwork(Ipv4Address address) NN_NOEXCEPT;

    Result GetConnectedNodeIpAddress(
        int* pOutCount, Ipv4Address* ipAddress, int ipAddressCount) NN_NOEXCEPT;

    Result GetSessionInfoFromNetwork(SessionInfo* pOutInfo) NN_NOEXCEPT;

    Result GetAdvertiseData(AdvertiseData* pOutData) NN_NOEXCEPT;

    Result GetAccessPointIpv4Address(Ipv4Address* pOutAddress) NN_NOEXCEPT;

    Result GetMyIpv4Address(Ipv4Address* pOutAddress) NN_NOEXCEPT;

    Result GetMacAddress(MacAddress* pOutMacaddress, Ipv4Address address) NN_NOEXCEPT;

    Result GetConnectedNodesCount(int *pOutCount) NN_NOEXCEPT;

    Result ConvertLdnResult(Result result) NN_NOEXCEPT;

    ContentsShareFailureReason GetContentsShareFailureReasonFromLdn() NN_NOEXCEPT;

}}} // end of namespace nn::lcs
