﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace lcs { namespace detail
{

    inline Bit32 GetUpper(Bit64 data)
    {
        return ((data & 0xFFFFFFFF00000000) >> 32);
    }

    inline Bit32 GetLower(Bit64 data)
    {
        return (data & 0x00000000FFFFFFFF);
    }

    inline Bit64 GetMerged(Bit32 upper, Bit32 lower)
    {
        Bit64 data = upper;
        data = data << 32;
        data += lower;
        return data;
    }

}}} // end of namespace nn::lcs
