﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/lcs/detail/Packet/lcs_Packet.h>

namespace nn { namespace lcs { namespace detail
{
    // パケットを見に行くまで待つ時間
    const int ReceiveIntervalMilliSeconds = 100;

    // パケットが届くまで待つ時間
    const int TimeoutMilliSeconds = 5000;

    Result DownloadAppControlDataSize(size_t *pOutAppDataSize,
        int socket, const nn::ncm::ApplicationId& id,
        void* packetBuffer, size_t packetBufferSize) NN_NOEXCEPT;

    Result DownloadAppControlData(
        void* pOutappDataBuffer, size_t appDataBufferSize, size_t *pOutAppDataSize,
        int socket, const nn::ncm::ApplicationId& id,
        void* packetBuffer, size_t packetBufferSize) NN_NOEXCEPT;

    Result SendAppControlDataRes(int socket, const nn::ncm::ApplicationId& id,
        void* buffer, size_t size, bool isSizeOnly) NN_NOEXCEPT;

    Result SendAcceptNode(int socket, uint32_t index) NN_NOEXCEPT;

    Result SendRejectNode(int socket, RejectReason reason) NN_NOEXCEPT;

    Result SendLeaveSession(int socket, LeaveReason reason) NN_NOEXCEPT;

    Result SendShareStart(int socket) NN_NOEXCEPT;

    Result SendShareEnd(int socket) NN_NOEXCEPT;

    Result SendShareEndWithProgress(int socket,
        const AdvertiseData& advertiseData) NN_NOEXCEPT;

    Result SendHostMigration(int socket, const MigrationInfo& info) NN_NOEXCEPT;

    Result SendResumeSession(int socket) NN_NOEXCEPT;

    Result SendNodeDetailInfo(
        int socket, char* name, const Version& lcsVersion, const SystemDeliveryInfo& sysInfo,
        const SessionInfo& sessionInfo, int downloadedContentCount,
        void* appDataBuffer, size_t appDataBufferSize, bool isUpdate) NN_NOEXCEPT;

    Result SendSessionInfo(int socket,
        int appCount, ApplicationInfo* appInfo, int nodeCount, NodeInfo* nodeInfo) NN_NOEXCEPT;

    Result SendShareSystemClear(int socket, SystemUpdateReason reason) NN_NOEXCEPT;

    Result SendShareSystemClearRes(int socket, Response response) NN_NOEXCEPT;

    Result SendShareSystemSendReq(
        int socket, TransferRole role, Ipv4Address address, uint32_t index, int channel) NN_NOEXCEPT;

    Result SendShareSystemSendRes(int socket, const SystemDeliveryInfo& sysInfo) NN_NOEXCEPT;

    Result SendShareSystemRecvReq(int socket, TransferRole role, Ipv4Address address, uint32_t index,
        const SystemDeliveryInfo& sysInfo, int channel) NN_NOEXCEPT;

    Result SendShareSystemRecvRes(int socket, Response response) NN_NOEXCEPT;

    Result SendShareContentClear(int socket,
        nn::util::BitFlagSet<8, ContentsType> contentsFlag, Bit64 id) NN_NOEXCEPT;

    Result SendShareContentClearRes(int socket, Response response) NN_NOEXCEPT;

    Result SendShareContentSendReq(
        int socket, TransferRole role, Ipv4Address address, uint32_t index, Bit64 id, int channel) NN_NOEXCEPT;

    Result SendShareContentSendRes(
        int socket, ContentMetaKey* metaKey, int metaKeyCount) NN_NOEXCEPT;

    Result SendShareContentRecvReq(int socket, TransferRole role, Ipv4Address address, uint32_t index,
        Bit64 id, ContentMetaKey* metaKey, int metaKeyCount, int channel) NN_NOEXCEPT;

    Result SendShareContentRecvRes(int socket, Response response) NN_NOEXCEPT;

    Result WaitJoinSessionRes(uint32_t* pOutIndex, int socket, void* packetBuffer, size_t packetBufferSize) NN_NOEXCEPT;

    Result WaitRecvData(int socket, void* buffer, size_t bufferSize) NN_NOEXCEPT;

}}} // end of namespace nn::lcs
