﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ldn/detail/ldn_Config.h>
#include <nn/ldn/ldn_PrivateResult.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>

/**
 * @brief         指定されたエラーコードで Abort します。
 */
#define NN_LCS_FATAL(result) NN_ABORT_UNLESS_RESULT_SUCCESS(result)

/**
 * @def           NN_LCS_REQUIRES_ARGUMENT
 * @brief         事前条件の検証を行います。
 * @details       Debug, Develop ビルドでは NN_SDK_REQUIRES と同じ挙動です。
 *                Release ビルドでは nn::lcs::ResultBadRequest で Abort します。
 */
#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    #define NN_LCS_REQUIRES(cond) NN_SDK_REQUIRES(cond)
#else
    #define NN_LCS_REQUIRES(cond) do { \
        if (cond) {} else { NN_LCS_FATAL(::nn::lcs::ResultBadRequest()); } \
    } while (NN_STATIC_CONDITION(false))
#endif

/**
 * @def           NN_LCS_REQUIRES_ALIGNED
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_ALIGNED(pointer, align) \
    NN_LCS_REQUIRES((reinterpret_cast<uintptr_t>(pointer) & ((align) - 1)) == 0U)

/**
 * @def           NN_LCS_REQUIRES_FALSE
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_FALSE(cond) NN_LCS_REQUIRES(!(cond))

/**
 * @def           NN_LCS_REQUIRES_EQUAL
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_EQUAL(lhs, rhs) NN_LCS_REQUIRES((lhs) == (rhs))

/**
 * @def           NN_LCS_REQUIRES_NOT_EQUAL
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_NOT_EQUAL(lhs, rhs) NN_LCS_REQUIRES((lhs) != (rhs))

/**
 * @def           NN_LCS_REQUIRES_GREATER
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_GREATER(lhs, rhs) NN_LCS_REQUIRES((lhs) > (rhs))

/**
 * @def           NN_LCS_REQUIRES_GREATER_EQUAL
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_GREATER_EQUAL(lhs, rhs) NN_LCS_REQUIRES((lhs) >= (rhs))

/**
 * @def           NN_LCS_REQUIRES_NULL
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_NULL(var) NN_LCS_REQUIRES((var) == nullptr)

/**
 * @def           NN_LCS_REQUIRES_NOT_NULL
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_NOT_NULL(var) NN_LCS_REQUIRES((var) != nullptr)

/**
 * @def           NN_LCS_REQUIRES_MINMAX
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_MINMAX(var, start, last)\
    NN_LCS_REQUIRES((start) <= (var) && (var) <= (last))

/**
 * @def           NN_LCS_REQUIRES_RANGE
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_RANGE(var, begin, end)\
    NN_LCS_REQUIRES((begin) <= (var) && (var) < (end))

/**
 * @def           NN_LCS_REQUIRES_INCLUDE
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_INCLUDE(var, ...) NN_LCS_REQUIRES(NN_LCS_INCLUDE(var, __VA_ARGS__))

/**
 * @def           NN_LCS_REQUIRES_NOT_INCLUDE
 * @brief         事前条件の検証を行います。
 */
#define NN_LCS_REQUIRES_NOT_INCLUDE(var, ...) NN_LCS_REQUIRES(!NN_LCS_INCLUDE(var, __VA_ARGS__))

#define NN_DETAIL_LCS_EXPAND(x) x
#define NN_DETAIL_LCS_GET_NAME(a1, a2, a3, a4, a5, a6, a7, a8, a9, name, ...) name
#define NN_DETAIL_LCS_INCLUDE1(var, n1) ((var) == (n1))
#define NN_DETAIL_LCS_INCLUDE2(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE1(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE3(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE2(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE4(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE3(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE5(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE4(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE6(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE5(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE7(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE6(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE8(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE7(var, __VA_ARGS__)))
#define NN_DETAIL_LCS_INCLUDE9(var, n1, ...)\
    (NN_DETAIL_LCS_INCLUDE1(var, n1) || \
     NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_INCLUDE8(var, __VA_ARGS__)))
#define NN_LCS_INCLUDE(var, ...) NN_DETAIL_LCS_EXPAND(NN_DETAIL_LCS_GET_NAME(\
    __VA_ARGS__,\
    NN_DETAIL_LCS_INCLUDE9,\
    NN_DETAIL_LCS_INCLUDE8,\
    NN_DETAIL_LCS_INCLUDE7,\
    NN_DETAIL_LCS_INCLUDE6,\
    NN_DETAIL_LCS_INCLUDE5,\
    NN_DETAIL_LCS_INCLUDE4,\
    NN_DETAIL_LCS_INCLUDE3,\
    NN_DETAIL_LCS_INCLUDE2,\
    NN_DETAIL_LCS_INCLUDE1)(var, __VA_ARGS__))
