﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Struct declaration for MarkerPositionReader
 */

#pragma once

#include <nn/util/util_MathTypes.h>

namespace nn { namespace irsensor {

const uint32_t MarkerPositionWidth = 540;  //!< image x resoltuion
const uint32_t MarkerPositionHeight = 380; //!< image y resoltuion

/**
* @brief Structure for storing MarkerPositionReader state
*/
struct MarkerPositionReaderState
{
    int64_t   samplingNumber;                   //!< sampling number that increments when new data arrives to system (more than 0).
    bool      isMarkerDetected;                 //!< if PositionReader found known marker or not from marker image.
    nn::util::Float2 pentipPosition;            //!< attachment's pentip 2D location where is contacting image plane.
    float     touchFactor;                      //!< it ranges 0 (no touch) to 1 (touch).
    nn::util::Matrix4x4fType cameraMatrix;      //!< irsensor's 3D rotation / translation matrix.
};

}} // namespace nn::irsensor

