﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   アプレット管理に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hidbus/system/hidbus_Common.h>

namespace nn { namespace hidbus { namespace system {

/**
 * @brief       アプレットリソースユーザ ID を設定します。
 *
 * @details     hidbus サービスの提供先をアプレットリソースユーザ ID で指定します。
 *              有効な AppletResourceUserId が指定されていなければ、
 *              hidbus サービスの提供先の制限は無効となります。
 *
 * @param[in]   value                       アプレットリソースユーザ ID
 */
void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& value
                             ) NN_NOEXCEPT;

/**
 * @brief       アプレットリソースユーザ ID を登録します。
 *
 * @details     アプレットリソースユーザ ID で指定された対象を hidbus サービスの
 *              提供先として登録します。
 *
 * @param[in]   aruid                       アプレットリソースユーザ ID
 * @param[in]   appletId                    アプレット ID
 *
 * @pre
 *              - aruid != nn::applet::AppletResourceUserId::GetInvalidId()
 */
void RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    ::nn::applet::AppletId appletId) NN_NOEXCEPT;

/**
 * @brief       アプレットリソースユーザ ID の登録を解除します。
 *
 * @details     アプレットリソースユーザ ID で指定された対象を hidbus サービスの
 *              提供先から削除します。
 *
 * @param[in]   aruid                       アプレットリソースユーザ ID
 *
 * @pre
 *              - aruid != nn::applet::AppletResourceUserId::GetInvalidId()
 */
void UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

}}} // namespace nn::hidbus::system
