﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hidbus/hidbus_IHidbusSystemServer.sfdl.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace hidbus { namespace server {

//!< hidbus system サービスを扱うクラスです。
class HidbusSystemServer final
{
    NN_DISALLOW_COPY(HidbusSystemServer);
    NN_DISALLOW_MOVE(HidbusSystemServer);

public:
    HidbusSystemServer() NN_NOEXCEPT;

    ~HidbusSystemServer() NN_NOEXCEPT;

    nn::Result SetAppletResourceUserId(nn::applet::AppletResourceUserId value) NN_NOEXCEPT;
    nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, int32_t appletId) NN_NOEXCEPT;
    nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

//!< hidbus system サービスのプロクシを作成します。
::nn::Result CreateHidbusSystemServerProxy(
    ::nn::sf::SharedPointer<IHidbusSystemServer>* outValue) NN_NOEXCEPT;

}}} // namespace nn::hidbus::server
