﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       本体 6 軸センサーに関する評価用途に限定した API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>

namespace nn { namespace hid { namespace tmp {

/**
 * @brief       3軸をもつセンサーの値 [count] を表す構造体です。
 *
 * @deprecated  SensorCountState は廃止されました。
 *
 */
struct SensorCountState
{
     int16_t x;  //!< センサーの x 軸の値
     int16_t y;  //!< センサーの y 軸の値
     int16_t z;  //!< センサーの z 軸の値
};

/**
 * @brief       本体 6 軸センサーのキャリブレーション値を表す構造体です。 <b>廃止予定です。</b>
 *
 * @deprecated  ConsoleSixAxisSensorCalibrationValues は廃止されました。
 *
 */
struct ConsoleSixAxisSensorCalibrationValues
{
    SensorCountState accelerationZeroCount;            //!< 加速度のゼロ点
    SensorCountState accelerationSensitivityCount;     //!< 加速度の感度
    SensorCountState angularVelocityZeroCount;         //!< 角速度のゼロ点
    SensorCountState angularVelocitySensitivityCount;  //!< 角速度の感度
};

/**
 * @brief       6軸センサーの入力状態 [count] を表す構造体です。
 *
 * @deprecated  SixAxisSensorCountState は廃止されました。
 *
 */
struct SixAxisSensorCountState
{
    ::nn::TimeSpanType        deltaTime;        //!< 前回サンプリングされてから今回のサンプリングまでの経過時間です。
    int64_t                   samplingNumber;   //!< 6 軸センサーの入力状態がサンプリングされる度に増加する値です。
    int64_t                   tick;             //!< サンプリング時点でのシステムチック値です。
    SensorCountState          acceleration;     //!< 加速度のカウント値。
    SensorCountState          angularVelocity;  //!< 角速度のカウント値。
};

//! @name 本体 6 軸センサー関連 API
//! @{

/**
 * @brief       SixAxisSensor の入力状態 [count] を過去に遡って読み出します。<b>廃止予定です。</b>
 *
 * @deprecated  GetConsoleSixAxisSensorCountStates() は廃止されました。
 *
 * @details     最新のものから過去に遡って利用可能な数だけ順に、指定の handle と対応する 6 軸センサーから入力状態を読み出します。
 *              利用可能な入力状態の数より大きなバッファ（配列）が指定された場合、余った領域に対しては何も行いません。
 *              読み出し可能な入力状態の最大数は ConsoleSixAxisSensorStateCountMax 個です。
 *              利用可能な入力状態には読み出し済みのものも含まれます。
 *              差分だけを利用したい場合は SixAxisSensorCountState::samplingNumber を参照してください。
 *              再解決の発生によって handle と対応するコントローラーの ID が解決状態でなくなった場合であっても、 SixAxisSensor の入力状態は無入力となります。
 *              本 API は評価用途での利用に限定され、製品環境では利用できません。将来的に廃止される予定です。
 *
 * @param[out]  outStates                   入力状態を読み出すバッファ（配列）
 * @param[in]   count                       読み出す入力状態の数
 * @param[in]   handle                      6軸センサーのハンドル
 *
 * @return      読み出した入力状態の数を返します。
 *
 * @pre
 *              - InitializeConsoleSixAxisSensor() の呼び出しが完了している
 *              - outStates != nullptr
 *              - count >= 0
 * @post
 *              - 戻り値 n について、n >= 0
 */
int GetConsoleSixAxisSensorCountStates(SixAxisSensorCountState* outStates,
                                       int count,
                                       const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

/**
 * @brief       SixAxisSensor のキャリブレーション値を読み出します。<b>廃止予定です。</b>
 *
 * @deprecated  GetConsoleSixAxisSensorCalibrationValues() は廃止されました。
 *
 * @details     SixAxisSensor のキャリブレーション値を読み出します。
 *              本 API は評価用途での利用に限定され、製品環境では利用できません。将来的に廃止される予定です。
 *
 * @param[out]  pOutCalibrationValues        キャリブレーション値を読み出すバッファ
 * @param[in]   handle                       6軸センサーのハンドル
 *
 * @pre
 *              - InitializeConsoleSixAxisSensor() の呼び出しが完了している
 *              - pOutCalibrationValues != nullptr
 */
void GetConsoleSixAxisSensorCalibrationValues(ConsoleSixAxisSensorCalibrationValues* pOutCalibrationValues,
                                              const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

//! @}

}}} // namespace nn::hid::tmp
