﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       振動に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace hid { namespace system {

//! @name 本体機能向け 振動 API
//! @{

/**
 * @brief       本体に保存された振動設定を無視して振動機能を許可します。
 * @details     nn::hid::IsVibrationPermitted() が false の際に、振動機能を許可します。\n
 *              本関数は本体に保存された振動設定を書き換えません。\n
 *              本関数を呼び出したアプリケーションが 「インフォーカス状態」でなくなった場合、\n
 *              もしくは nn::hid::EndPermitVibrationSession() を呼び出した際に、振動機能を許可する期間は終了します。\n
 *              アプリケーションが「インフォーカス状態」以外から「インフォーカス状態」に遷移した際に、振動機能を許可するためには、本関数を再度呼び出す必要があります。\n
 *              「インフォーカス状態」に関しては、NintendoSDK ドキュメントの　機能 > プログラムの流れ > プログラムへの通知メッセージ を参照ください。
 */
void BeginPermitVibrationSession() NN_NOEXCEPT;

/**
 * @brief       本体に保存された振動設定を無視して振動機能を許可する期間を終了します。
 * @details     本体に保存された振動設定を反映します。
 */
void EndPermitVibrationSession() NN_NOEXCEPT;

//! @}

}}} // namespace nn::hid::system
