﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Npad に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_ControlPadTypes.h>
#include <nn/hid/hid_NpadCommonTypes.h>

namespace nn { namespace hid {

//! @name Npad の十字ボタンの禁則処理関連 API
//! @{

/**
 * @brief       十字ボタンの禁則処理の種類を設定します
 *
 * @details     コントローラーのボタンの入力状態を読み出す際の十字ボタンの禁則処理の種類を設定します
 *              禁則処理の方法は Npad のスタイル毎に設定できます
 *              スタイルを複数同時に指定することで、一度に複数のスタイルに対して設定することが可能です。
 *              デフォルトの禁則処理の方法は、Npad の操作スタイル毎に異なります。
 *              詳しくは各 NpadXXXState の説明を確認してください
 *
 * @param[in]   style                      設定の対象となる操作スタイル
 * @param[in]   type                       有効にする禁則処理の方法
 *
 * @pre
 *              - style.CountPopulation() > 0
 */
void SetControlPadRestrictionType(NpadStyleSet style, ControlPadRestrictionType type) NN_NOEXCEPT;

/**
 * @brief       十字ボタンの禁則処理の種類を取得します
 *
 * @details     コントローラーの十字ボタンに対して設定されている禁則処理の方法を取得します。
 *              禁則処理の方法は Npad のスタイル毎に取得します
 *              設定を取得する際は、スタイルは 1つだけ指定します。
 *
 * @param[in]   style                      設定の対象となる操作スタイル
 *
 * @return      Npad の操作スタイルです。
 *
 * @pre
 *              - style.CountPopulation() == 1
 */
ControlPadRestrictionType GetControlPadRestrictionType(NpadStyleSet style) NN_NOEXCEPT;


//! @}

}} // namespace nn::hid
