﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       GamePad に関する API の宣言
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace hid {

const int GamePadCountMax = 16; //!< GamePad の最大数

/**
 * @brief       GamePad のデジタルボタン定義です。
 */
struct GamePadButton
{
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<0> B;       //!< GamePad の B ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<1> A;       //!< GamePad の A ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<2> Y;       //!< GamePad の Y ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<3> X;       //!< GamePad の X ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<4> L;       //!< GamePad の L ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<5> R;       //!< GamePad の R ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<6> Select;  //!< GamePad の SELECT ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<7> Start;   //!< GamePad の START ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<8> StickL;  //!< GamePad の L スティックボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<9> StickR;  //!< GamePad の R スティックボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<10> ZL;     //!< GamePad の ZL ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<11> ZR;     //!< GamePad の ZR ボタン
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<12> Left;   //!< GamePad の十字ボタン 左
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<13> Up;     //!< GamePad の十字ボタン 上
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<14> Right;  //!< GamePad の十字ボタン 右
    typedef ::nn::util::BitFlagSet<32, GamePadButton>::Flag<15> Down;   //!< GamePad の十字ボタン 下
};

/**
 * @brief       GamePad のデジタルボタンの集合を扱う型です。
 */
typedef ::nn::util::BitFlagSet<32, GamePadButton> GamePadButtonSet;

}} // namespace nn::hid
