﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       バッテリー残量に関する API の宣言
 */

#pragma once

namespace nn { namespace hid {

/**
 * @brief       バッテリー残量の定義です。
 */
enum BatteryLevel
{
    BatteryLevel_Empty,     //!< バッテリー残量はゼロです。
    BatteryLevel_Critical,  //!< バッテリー残量がほとんど残っていません。
    BatteryLevel_Low,       //!< バッテリー残量が少なくなっています。
    BatteryLevel_Medium,    //!< バッテリー残量は約半分です。
    BatteryLevel_High,      //!< バッテリー残量は十分です。
    BatteryLevel_Full,      //!< バッテリー残量は最大です。
};

}} // namespace nn::hid
