﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Usb コントローラのデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       任意の USB コントローラの接続処理を行います。
 *
 * @details     呼び出し時点で USB 接続されている任意の USB コントローラを
 *              Npad として登録します。
 *              登録処理は非同期に行われ、呼び出し完了時点で登録されていることは保証されません。
 */
void ConnectUsbPadsAsync() NN_NOEXCEPT;

/**
 * @brief       任意の USB コントローラの切断処理を行います。
 *
 * @details     呼び出し時点で Npad として登録されている任意の USB コントローラの
 *              登録を削除します。
 *              削除処理は非同期に行われ、呼び出し完了時点で登録されていることは保証されません。
 */
void DisconnectUsbPadsAsync() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
