﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ホームボタンのデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_HomeButton.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       ホームボタンの自動操作状態を表す構造体です。
 */
struct HomeButtonAutoPilotState
{
    ::nn::hid::system::HomeButtonSet buttons;   //!< ホームボタンのデジタルボタンの状態です。
};

/**
 * @brief       ホームボタンをファイナライズします。
 *
 * @details     事前に nn::hid::system::InitializeHomeButton() を呼び出した
 *              回数と同じだけ呼びだされた際にホームボタンが初期化状態を
 *              解除します。
 *
 * @pre
 *              - ホームボタンが初期化状態にある
 */
void FinalizeHomeButton() NN_NOEXCEPT;

/**
 * @brief       ホームボタンに自動操作状態を設定します。
 *
 * @param[in]   value                       ホームボタンの自動操作状態
 *
 * @pre
 *              - ホームボタンが初期化状態にある
 */
void SetHomeButtonAutoPilotState(const HomeButtonAutoPilotState& value
                                 ) NN_NOEXCEPT;

/**
 * @brief       ホームボタンの自動操作状態を解除します。
 *
 * @pre
 *              - ホームボタンが初期化状態にある
 */
void UnsetHomeButtonAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
