﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file  helloworld_GetString.h
* @brief Hello World 文字列の取得機能を提供する関数を宣言します。
*/

#pragma once

#include <nn/helloworld/helloworld_Language.h>


namespace nn { namespace helloworld {

//----------------------------------------------------------------------------
/**
* @brief  "Hello, World!" という定数文字列へのポインタを取得します。
*
* @return  "Hello, World!" という定数文字列へのポインタです。
* @details この関数は、常に同じ文字列へのポインタを返します。
*/
const char* GetHelloWorldString();

//----------------------------------------------------------------------------
/**
* @brief     特定の言語に翻訳された "Hello, World!" 相当の定数文字列へのポインタを取得します。
*
* @param[in] language 翻訳先の言語を指定します。
* @return    引数 language が指す言語に翻訳された、"Hello, World!" と同じ意味の定数文字列への
             ポインタが返ります。
* @retval    "Hello, World!"          Language::English を選択した場合の文字列です。文字列の内容は
                                      GetHelloWorldString() の戻り値と同じです。
* @retval    "Hallo, Welt!"           Language::German を選択した場合の文字列です。
* @retval    "Bonjour Tout Le Monde!" Language::French を選択した場合の文字列です。
* @retval    "こんにちは、世界！"     Language::Japanese を選択した場合の文字列です。
* @retval    nullptr                  それ以外の値を入力した場合の戻り値です。
* @pre       引数の language は、Language 型の列挙子として定義されている値でなければなりません。
             不正な値を入力すると、関数の返り値として nullptr が返ります。
* @details   英語、ドイツ語、フランス語、日本語のいずれかの言語に翻訳された、"Hello, World!" と
             同じ意味の定数文字列へのポインタを取得します。
*/
const char* GetTranslatedHelloWorldString(Language language);

}}
