﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_File.h>
#include <nn/capsrv/capsrv_ScreenShotAttribute.h>

namespace nn { namespace grcsrv { namespace trimming {

class MovieTrimmerImpl;

class MovieTrimmer
{
private:

    Bit64 m_ImplBuffer[16];
    MovieTrimmerImpl* m_pImpl;

public:

    explicit MovieTrimmer() NN_NOEXCEPT;
    ~MovieTrimmer() NN_NOEXCEPT;

    Result Initialize(fs::FileHandle handle, void* buffer, size_t bufferSize) NN_NOEXCEPT;
    Result ReadHeader() NN_NOEXCEPT;
    Result Trim(int* pFrameCount, fs::FileHandle handle, int beginIndex, int endIndex, const capsrv::ScreenShotAttribute& attribute) NN_NOEXCEPT;

};

void InitializeTrimmingStatic() NN_NOEXCEPT;

}}}
