﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/grc/grc_ResultPrivate.h>

namespace nn{ namespace grcsrv{ namespace offscreen{

    class CheckPointForTesting
    {
    public:
        enum CheckPoint
        {
            CheckPoint_Invalid = 0,

            CheckPoint_FinishLayerRecordingBegin,
            CheckPoint_FinishLayerRecordingPrecondition = CheckPoint_FinishLayerRecordingBegin,
            CheckPoint_FinishLayerRecordingCheckLayerFinishReady,
            CheckPoint_FinishLayerRecordingGetLastCaptureBufferIndex,
            CheckPoint_FinishLayerRecordingFinishLayer,
            CheckPoint_FinishLayerRecordingFlushFile,
            CheckPoint_FinishLayerRecordingGetMovieDataSize,
            CheckPoint_FinishLayerRecordingDetachFile,
            CheckPoint_FinishLayerRecordingEndDataSection,
            CheckPoint_FinishLayerRecordingBuildMetaData,
            CheckPoint_FinishLayerRecordingStartMetaSection,
            CheckPoint_FinishLayerRecordingWriteMetaData,
            CheckPoint_FinishLayerRecordingEndMetaSection,
            CheckPoint_FinishLayerRecordingFinishStream,
            CheckPoint_FinishLayerRecordingCommitStream,
            CheckPoint_FinishLayerRecordingEnd,
        };

    public:
        static nn::Result GetResultValue(uint64_t checkpoint) NN_NOEXCEPT
        {
            if(checkpoint == CheckPoint_Invalid)
            {
                return nn::ResultSuccess();
            }

            const int ResultTypeCount = 9;

            switch(checkpoint % ResultTypeCount)
            {
            case 0: return nn::grc::ResultInternalTesting01();
            case 1: return nn::grc::ResultInternalTesting02();
            case 2: return nn::grc::ResultInternalTesting03();
            case 3: return nn::grc::ResultInternalTesting04();
            case 4: return nn::grc::ResultInternalTesting05();
            case 5: return nn::grc::ResultInternalTesting06();
            case 6: return nn::grc::ResultInternalTesting07();
            case 7: return nn::grc::ResultInternalTesting08();
            case 8: return nn::grc::ResultInternalTesting09();
            default: NN_UNEXPECTED_DEFAULT;
            }
        }
    };

    extern std::atomic_uint64_t g_TestingCheckPoint;

#define NN_GRCSRV_THROW_CHECKPOINT(value)   \
    if((value) == g_TestingCheckPoint)      \
    {                                       \
        return nn::grcsrv::offscreen::CheckPointForTesting::GetResultValue(value);  \
    }


}}}
