﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio> // TODO
#include <functional>
#include <exception>
#include <vector>

#include <nn/nn_Macro.h>

#include <nn/gfxTool/gfxTool_ResultCode.h>
#include <nn/gfxTool/gfxTool_Custom.h>

#define NN_GFXTOOL_THROW_MSG( code, format, ... ) \
    throw ::nn::gfxTool::Exception( __FILE__, __LINE__, code, format, __VA_ARGS__ )
#define NN_GFXTOOL_THROW( code ) NN_GFXTOOL_THROW_MSG( code, "" )
#define TODO_THROW NN_GFXTOOL_THROW( nngfxToolResultCode_Failed )

// TODO
#define NN_GFXTOOL_PRINT( format, ...) \
    nn::gfxTool::Logger::PrintFormat( nn::gfxTool::Logger::LogType::Default, \
    nn::gfxTool::Logger::LogLevel::Medium, format, __VA_ARGS__ );
#define NN_GFXTOOL_PRINT_ERROR( format, ...) \
    nn::gfxTool::Logger::PrintFormat( nn::gfxTool::Logger::LogType::Error,\
    nn::gfxTool::Logger::LogLevel::Medium, format, __VA_ARGS__ );
#define NN_GFXTOOL_PRINT_WARNING( format, ... ) \
    nn::gfxTool::Logger::PrintFormat( nn::gfxTool::Logger::LogType::Warning, \
    nn::gfxTool::Logger::LogLevel::Medium, format, __VA_ARGS__ );

namespace nn {
namespace gfxTool {

nngfxToolResultCode ReportException();

class Exception
    : public std::exception
{
public:
    Exception( const char* pFileName, int line, nngfxToolResultCode code, const char* pFormat, ... );

    const char* what() const override
    {
        return &m_What[ 0 ];
    }

    const char* GetMessage() const
    {
        return &m_Message[ 0 ];
    }

    nngfxToolResultCode GetResultCode() const
    {
        return m_Code;
    }

    int GetLine() const
    {
        return m_Line;
    }

    const char* GetFileName() const
    {
        return m_FileName.data();
    }

private:
    Custom< std::vector< char > >::Type m_What;
    Custom< std::vector< char > >::Type m_Message;
    nngfxToolResultCode m_Code;
    int m_Line;
    Custom< std::string >::Type m_FileName;
};

class Logger
{
public:
    enum class LogType
    {
        Default,
        Warning,
        Error,

        End
    };

    enum class LogLevel
    {
        Silent,
        Low,
        Medium,
        High,

        End
    };

    static void PrintFormat( LogType type, LogLevel level, const char* pFormat, ... );
    static void SetLogOutputLevel( LogType type, LogLevel level );
    static void* GetStream( LogType type );
    static void SetStream( LogType type, void* stream );
    static void SetDefaultStream();

private:
    static LogLevel s_LogOutputLevels[ static_cast< int >( LogType::End ) ];
    static void* s_Streams[ static_cast< int >( LogType::End ) ];
};

}
}
