﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

namespace nn {
namespace gfxTool {

// VS2012
template< typename T >
struct Custom;
template< typename T >
struct Custom< std::allocator< T > >
{
    typedef std::allocator< T > Type;
};
template< typename... Args >
struct Custom< std::unique_ptr< Args... > >
{
    typedef std::unique_ptr< Args... > Type;
};
template< template< typename > class T, typename A >
struct Custom< T< std::allocator< A > > >
{
    typedef T< typename Custom< std::allocator< A > >::Type > Type;
};
template< template< typename, typename > class T, typename A, typename T1 >
struct Custom< T< T1, std::allocator< A > > >
{
    typedef T< T1, typename Custom< std::allocator< A > >::Type > Type;
};
template< template< typename, typename, typename > class T,
    typename A, typename T1, typename T2 >
struct Custom< T< T1, T2, std::allocator< A > > >
{
    typedef T< T1, T2, typename Custom< std::allocator< A > >::Type > Type;
};
template< template< typename, typename, typename, typename > class T,
    typename A, typename T1, typename T2, typename T3 >
struct Custom< T< T1, T2, T3, std::allocator< A > > >
{
    typedef T< T1, T2, T3, typename Custom< std::allocator< A > >::Type > Type;
};
template< template< typename, typename, typename, typename, typename > class T,
    typename A, typename T1, typename T2, typename T3, typename T4 >
struct Custom< T< T1, T2, T3, T4, std::allocator< A > > >
{
    typedef T< T1, T2, T3, T4, typename Custom< std::allocator< A > >::Type > Type;
};

template< typename T >
using CustomType = typename Custom< T >::Type;

}
}
