﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_VariationBase.h>

namespace nn {
namespace gfx {

enum /* LowLevelApi */
{
    LowLevelApi_D3d = NN_GFX_CONFIG_API_TYPE_D3D
};

/**
* @brief D3D を表す型定義です。
*/
typedef ApiType< LowLevelApi_D3d > ApiTypeD3d;

/**
* @brief D3D11 API を表す型定義です。
*/
typedef ApiVariation< ApiTypeD3d, ApiVersion< 11 > > ApiVariationD3d11;

template<>
struct DefaultVersion< ApiTypeD3d >
{
    typedef ApiVersion< NN_GFX_CONFIG_D3D_DEFAULT_VERSION > Version;
};

template<>
struct TargetVersion< ApiTypeD3d >
{
    typedef ApiVersion< NN_GFX_CONFIG_D3D_TARGET_VERSION > Version;
};

}
}
