﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief テクスチャのデータに関する API の宣言（GX2 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief テクスチャを表す構造体です（GX2 特殊版）
*/
template<>
struct TextureImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    NN_PADDING2;

    struct
    {
        uint32_t surfaceWord[ 29 ];
    } gx2Surface;

    detail::Ptr< void > pGx2Surface;

    detail::Ptr< void > userPtr; //!< ユーザポインタです
};

/**
* @brief テクスチャビューを表す構造体です（GX2 特殊版）
*/
template<>
struct TextureViewImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    NN_PADDING2;

    struct
    {
        uint32_t textureWord[ 39 ];
    } gx2Texture;

    detail::Ptr< void > pGx2Texture;

    detail::Ptr< void> userPtr; //!< ユーザポインタです
};

/**
* @brief カラーターゲットビューを表す構造体です（GX2 特殊版）
*/
template<>
struct ColorTargetViewImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    NN_PADDING2;

    struct
    {
        uint32_t colorBufferWord[ 39 ];
    } gx2ColorBuffer;

    detail::Ptr< void > pGx2ColorBuffer;

    detail::Ptr< void > userPtr; //!< ユーザポインタです
};

/**
* @brief 深度ステンシルビューを表す構造体です（GX2 特殊版）
*/
template<>
struct DepthStencilViewImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    NN_PADDING2;

    struct
    {
        uint32_t depthBufferWord[ 43 ];
    } gx2DepthBuffer;

    detail::Ptr< void > pGx2DepthBuffer;

    detail::Ptr< void > userPtr; //!< ユーザポインタです
};

}
}
